#!/bin/bash

module load anaconda/3
conda activate RelationalNetworks

model=$1
data=$2
iterations=$3
dim=$4
heads=$5
qk_dim=$6
rules=$7
seed=$8
extras=$9

ext=${extras//\-\-/\_}
ext=${ext// /}

name="VIT_"$data"_"$model"_"$iterations"_"$dim"_"$heads"_"$rules"_"$qk_dim"_"$seed""$ext

echo Running on $HOSTNAME
echo Running version $name
echo Extra arguments: $extras

python main.py --epochs 200 --model $model \
--transformer-dim $dim --n-heads $heads --n-rules $rules --seed $seed \
--iterations $iterations --name $name --qk-dim $qk_dim --dataset $data $extras